using MCSHelperClass;
using MCSUtilities2011;
using Microsoft.Xrm.Sdk;
using System;
using Microsoft.Xrm.Sdk.Client;

namespace MCSPlugins
{
    public abstract class PluginRunner
    {
        #region Private Fields
        private readonly IServiceProvider _serviceProvider;
        private IPluginExecutionContext _pluginExecutionContext;
        private IOrganizationServiceFactory _organizationServiceFactory;
        private OrganizationServiceContext _organizationServiceContext;
        private IOrganizationService _organizationService;
        private ITracingService _tracingService;
        private MCSLogger _logger;
        private UtilityFunctions _utilityFunctions;
        private MCSSettings _mcsSettings;
        private MCSHelper _mcsHelper;
        #endregion

        #region Constructor
        protected PluginRunner(IServiceProvider serviceProvider)
        {
            if (serviceProvider == null)
                throw new ArgumentNullException("serviceProvider");

            _serviceProvider = serviceProvider;

            Logger.setDebug = McsSettings.getDebug;
            Logger.setTxnTiming = McsSettings.getTxnTiming;
            Logger.setGranularTiming = McsSettings.getGranular;
            McsSettings.setLogger = Logger;
        }
        #endregion

        #region Internal Methods/Properties
        internal IServiceProvider ServiceProvider
        {
            get
            {
                return _serviceProvider;
            }
        }

        internal IPluginExecutionContext PluginExecutionContext
        {
            get
            {
                return _pluginExecutionContext ??
                       (_pluginExecutionContext =
                        (IPluginExecutionContext)ServiceProvider.GetService(typeof(IPluginExecutionContext)));
            }
        }

        internal IOrganizationServiceFactory OrganizationServiceFactory
        {
            get
            {
                return _organizationServiceFactory ??
                       (_organizationServiceFactory =
                        (IOrganizationServiceFactory)ServiceProvider.GetService(typeof(IOrganizationServiceFactory)));
            }
        }

        internal IOrganizationService OrganizationService
        {
            get
            {
                return _organizationService ??
                       (_organizationService =
                        OrganizationServiceFactory.CreateOrganizationService(PluginExecutionContext.InitiatingUserId));
            }
        }
        internal OrganizationServiceContext OrganizationServiceContext
        {
            get
            {
                return _organizationServiceContext ??
                       (_organizationServiceContext = new OrganizationServiceContext(OrganizationService));
            }
        }
        internal ITracingService TracingService
        {
            get
            {
                return _tracingService ??
                       (_tracingService =
                        (ITracingService)ServiceProvider.GetService(typeof(ITracingService)));
            }
        }

        internal MCSLogger Logger
        {
            get
            {
                return _logger ??
                       (_logger = new MCSLogger
                       {
                           setService = OrganizationService,
                           setTracingService = TracingService,
                           setModule = String.Format("{0}:", GetType())
                       });
            }
        }

        internal UtilityFunctions Utilities
        {
            get
            {
                return _utilityFunctions ??
                    (_utilityFunctions = new UtilityFunctions
                    {
                        setService = OrganizationService,
                        setlogger = Logger
                    });
            }
        }

        internal MCSSettings McsSettings
        {
            get
            {
                if (_mcsSettings == null)
                {
                    _mcsSettings = new MCSSettings
                    {
                        setService = OrganizationService,
                        setDebugField = McsSettingsDebugField,
                        systemSetting = "Active Settings",
                        setLogger = Logger
                    };

                    _mcsSettings.GetStartupSettings();
                }

                return _mcsSettings;
            }
        }

        internal MCSHelper McsHelper
        {
            get
            {
                return _mcsHelper ?? (_mcsHelper = new MCSHelper(GetPrimaryEntity(), GetSecondaryEntity()));
            }
        }
        public abstract Entity GetPrimaryEntity();

        public abstract Entity GetSecondaryEntity();

        public abstract string McsSettingsDebugField { get; }
        #endregion
    }
}
